# The Notenik Mac App

Notenik is a modern, powerful note-taking application written in Swift.

This is one of several active repositories on GitHub containing code and/or documentation related to the Notenik Mac App. The programming code is written in Swift, and the documentation is offered in a series of separate Notenik Collections, authored in Markdown. 

(There are also some inactive repos concerning an earlier version of Notenik, written in Java, and these will not be further mentioned in this README.)

## Notenik Links Outside of GitHub

Use these links to obtain more info about the app, and to actually download a working version to your Mac. 

+ [Notenik.app](https://notenik.app) - The Notenik website
+ [Notenik 101](https://youtu.be/JR0kpAUXM5E) - An introductory video hosted on YouTube
+ [Notenik on the Mac App Store](https://apps.apple.com/us/app/notenik/id1465997984) - A direct link to Notenik in the App Store
+ [Notenik Discourse Forum](https://discourse.notenik.app) - A dedicated Discourse Community for Notenik

## Notenik Code Repos

This is all of the Swift code written as part of the Notenik application. These are all released under the terms of the MIT License. 

+ [Notenik-25](https://github.com/hbowie/Notenik-25) - The latest version of the Mac UI, written using AppKit/Cocoa, with commit history starting in 2025
+ [notenik-swift](https://github.com/hbowie/notenik-swift) - The Mac UI, written using AppKit/Cocoa, updated through (nearly) the end of 2024
+ [NotenikLib](https://github.com/hbowie/NotenikLib) - Underlying code that does not need Cocoa
+ [NotenikUtils](https://github.com/hbowie/NotenikUtils) - General-purpose utilities
+ [NotenikTextile](https://github.com/hbowie/NotenikTextile) - A very basic and incomplete parser for Textile
+ [NotenikMkdown](https://github.com/hbowie/NotenikMkdown) - Notenik's custom Markdown parser

## Documentation Collections

These collections contain various sorts of documentation about Notenik. These are organized as Notenik Collections (that can be opened using Notenik).

+ [Notenik Docs](https://github.com/hbowie/NotenikDocs) - All the available documentation about Notenik.
+ [Website](https://github.com/hbowie/notenik-web) - The files needed to generate and maintain the Notenik.app website

## Additional Code Packages

This is additional open-source code, written by others, and used by Notenik. These packages are all separately licensed. 

+ [cmark](https://github.com/commonmark/cmark)
+ [CoreXLSX](https://github.com/MaxDesiatov/CoreXLSX)
+ [Down](https://github.com/iwasrobbed/Down)
+ [Ink](https://github.com/JohnSundell/Ink)
+ [MathJax](https://www.mathjax.org)
+ [SwiftHTMLToMarkdown](https://github.com/ActuallyTaylor/SwiftHTMLToMarkdown)
+ [SwiftSoup](https://github.com/scinfu/SwiftSoup.git)
+ [TrackerZapper](https://github.com/rknightuk/TrackerZapper)
+ [XMLCoder](https://github.com/MaxDesiatov/XMLCoder)
+ [ZIPFoundation](https://github.com/weichsel/ZIPFoundation)
